/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool.demos;

import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.MediaToolAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IAudioSamplesEvent;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.nio.ShortBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyAudioAndVideo {
    private static final Logger log = LoggerFactory.getLogger(ModifyAudioAndVideo.class);

    public ModifyAudioAndVideo() {
        log.trace("<init>");
    }

    public static void main(String[] args) {
        File inputFile;
        if (args.length < 2) {
            System.out.println("Usage: ModifyAudioAndVideo <inputFileName> <outputFileName>");
            System.exit(-1);
        }
        if (!(inputFile = new File(args[0])).exists()) {
            System.out.println("Input file does not exist: " + inputFile);
            System.exit(-1);
        }
        File outputFile = new File(args[1]);
        IMediaReader reader = ToolFactory.makeReader(inputFile.toString());
        reader.setBufferedImageTypeToGenerate(5);
        IMediaWriter writer = ToolFactory.makeWriter(outputFile.toString(), reader);
        TimeStampTool addTimeStamp = new TimeStampTool();
        VolumeAdjustTool reduceVolume = new VolumeAdjustTool(0.1);
        reader.addListener(addTimeStamp);
        addTimeStamp.addListener(reduceVolume);
        reduceVolume.addListener(writer);
        writer.addListener(ToolFactory.makeViewer());
        while (reader.readPacket() == null) {
        }
    }

    static class VolumeAdjustTool
    extends MediaToolAdapter {
        private double mVolume;

        public VolumeAdjustTool(double volume) {
            this.mVolume = volume;
        }

        @Override
        public void onAudioSamples(IAudioSamplesEvent event) {
            ShortBuffer buffer = event.getAudioSamples().getByteBuffer().asShortBuffer();
            for (int i = 0; i < buffer.limit(); ++i) {
                buffer.put(i, (short)((double)buffer.get(i) * this.mVolume));
            }
            super.onAudioSamples(event);
        }
    }

    static class TimeStampTool
    extends MediaToolAdapter {
        TimeStampTool() {
        }

        @Override
        public void onVideoPicture(IVideoPictureEvent event) {
            Graphics2D g = event.getImage().createGraphics();
            String timeStampStr = event.getPicture().getFormattedTimeStamp();
            Rectangle2D bounds = g.getFont().getStringBounds(timeStampStr, g.getFontRenderContext());
            double inset = bounds.getHeight() / 2.0;
            g.translate(inset, (double)event.getImage().getHeight() - inset);
            g.setColor(Color.WHITE);
            g.fill(bounds);
            g.setColor(Color.BLACK);
            g.drawString(timeStampStr, 0, 0);
            super.onVideoPicture(event);
        }
    }
}

